/* Alterações Ticket #35 */
INSERT INTO `tacessosubtela` (
`ID_AcessoSubTela` ,
`ID_AcessoTela` ,
`Desc_AcessoSubTela`
)
VALUES (
101 , '8', 'Relatórios - Aceite de Contrato'
);

/* Alterações ticket #36 */

/* cancela todas as parcelas dos alunos que ainda não deram aceite de contrato */
update 
tcontareceber cr 
left join tturma t on cr.ID_Turma = t.ID_Turma 
left join tcurso c on t.ID_Curso = c.ID_Curso 
left join taceite_contrato ac on cr.ID_Turma = ac.ID_Turma 
                              and cr.ID_Aluno = ac.ID_Aluno 
left join tcontarecebercategoria crc on cr.Categ_ContaReceber = crc.ID_CategoriaContaReceber 

set ID_ContaReceberStatus = 3

where c.EAD = 1 
and (ac.aceite = 0 or ac.aceite is null) 
and cr.ID_ContaReceberStatus = 0 
and cr.ID_Aluno not in (42789, 74217) 
and cr.Desconto_ContaReceber < 100

/* delete aceite contrato de alunos inexistentes */
delete taceite_contrato from `taceite_contrato` LEFT JOIN taluno USING (ID_Aluno)
WHERE taluno.ID_Aluno IS NULL
/* inclui chave estrangeira */
ALTER TABLE `taceite_contrato` ADD `user_agent` VARCHAR( 100 ) NOT NULL, 
ADD CONSTRAINT `FK_Turma` FOREIGN KEY ( `ID_Turma` ) REFERENCES `tturma` ( `ID_Turma` ),
ADD CONSTRAINT `FK_Aluno` FOREIGN KEY ( `ID_Aluno` ) REFERENCES `taluno` ( `ID_Aluno` ) ; 
/* renomeia a tabela */
RENAME TABLE `taceite_contrato` TO `aceitecontrato` ;
/* troca o charset para utf-8 */
ALTER TABLE `aceitecontrato` DEFAULT CHARACTER SET utf8 COLLATE utf8_unicode_ci
/* inclui a configuração de contrato */
INSERT INTO `tconfiguracao` (
`ID_Configuracao` ,
`Desc_Configuracao` ,
`Valor_Configuracao`
)
VALUES (
'9', 'Tele de Aceite Contrato EAD', '0'
);

